package gov.va.vinci.dart.db;

import java.util.List;

import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

import gov.va.vinci.dart.common.SingletonShim;
import gov.va.vinci.dart.common.test.BusinessIntegrationTest;
import gov.va.vinci.dart.biz.DartRequest;
import gov.va.vinci.dart.biz.DocumentTemplate;
import gov.va.vinci.dart.biz.Group;
import gov.va.vinci.dart.biz.Location;
import gov.va.vinci.dart.biz.Person;
import gov.va.vinci.dart.biz.RequestLocationDocument;
import gov.va.vinci.dart.dms.biz.Document;
import gov.va.vinci.dart.service.DartObjectFactory;

public class TestRequestLocationDocumentDAO extends BusinessIntegrationTest {

	@BeforeTest
	public void setup() {
		SingletonShim.getBean(DartObjectFactory.class);
	}
	
	@Test
	public void testOne() throws Exception {
		List<DartRequest> reqList = DartObjectFactory.getInstance().getDartRequestDAO().listAll();
		Assert.assertNotNull(reqList);
		Assert.assertTrue(reqList.size() > 0);
		
		DartRequest request = reqList.get(0);
		Assert.assertNotNull(request);
		Assert.assertTrue(request.getId() > 0);

		Person pers = DartObjectFactory.getInstance().getPersonDAO().findById(1006);
		Assert.assertNotNull(pers);
		Assert.assertTrue(pers.getId() > 0);
		Assert.assertNotNull(pers.getGroups());
		Assert.assertTrue(pers.getGroups().size() > 0);
		
		Group group = pers.getGroups().iterator().next();
		Assert.assertNotNull(group);
		Assert.assertTrue(group.getId() > 0);

		Location location = pers.getLocation();
		Assert.assertNotNull(location);
		Assert.assertTrue(location.getId() > 0);
		
		List<DocumentTemplate> dtList = DartObjectFactory.getInstance().getDocumentTemplateDAO().listAll();
		Assert.assertNotNull(dtList);
		Assert.assertTrue(dtList.size() > 0);
		
		DocumentTemplate template = dtList.get(0);
		Assert.assertNotNull(template);
		Assert.assertTrue(template.getId() > 0);
		
		Document doc = Document.create(request, template, pers.getName());
		Assert.assertNotNull(doc);
		Assert.assertTrue(doc.getId() > 0);

		RequestLocationDocument rald = RequestLocationDocument.create(request, location, doc);
		Assert.assertNotNull(rald);
		Assert.assertTrue(rald.getId() > 0);
		
		List<RequestLocationDocument> raldList = DartObjectFactory.getInstance().getRequestLocationDocumentDAO().listByRequestId(request.getId());
		Assert.assertNotNull(raldList);
		Assert.assertTrue(raldList.size() > 0);
		Assert.assertTrue(raldList.contains(rald));
		
		raldList = DartObjectFactory.getInstance().getRequestLocationDocumentDAO().listByRequestId(10000);
		Assert.assertNotNull(raldList);
		Assert.assertEquals(raldList.size(), 0);

	}

	@Test
	public void testTwo() throws Exception {
		List<DartRequest> reqList = DartObjectFactory.getInstance().getDartRequestDAO().listAll();
		Assert.assertNotNull(reqList);
		Assert.assertTrue(reqList.size() > 0);
		
		DartRequest request = reqList.get(0);
		Assert.assertNotNull(request);
		Assert.assertTrue(request.getId() > 0);

		Person pers = DartObjectFactory.getInstance().getPersonDAO().findById(1006);
		Assert.assertNotNull(pers);
		Assert.assertTrue(pers.getId() > 0);
		Assert.assertNotNull(pers.getGroups());
		Assert.assertTrue(pers.getGroups().size() > 0);
		
		Group group = pers.getGroups().iterator().next();
		Assert.assertNotNull(group);
		Assert.assertTrue(group.getId() > 0);

		Location location = pers.getLocation();
		Assert.assertNotNull(location);
		Assert.assertTrue(location.getId() > 0);
		
		List<DocumentTemplate> dtList = DartObjectFactory.getInstance().getDocumentTemplateDAO().listAll();
		Assert.assertNotNull(dtList);
		Assert.assertTrue(dtList.size() > 0);
		
		DocumentTemplate template = dtList.get(0);
		Assert.assertNotNull(template);
		Assert.assertTrue(template.getId() > 0);
		
		Document doc = Document.create(request, template, pers.getName());
		Assert.assertNotNull(doc);
		Assert.assertTrue(doc.getId() > 0);

		RequestLocationDocument rald = RequestLocationDocument.create(request, location, doc);
		Assert.assertNotNull(rald);
		Assert.assertTrue(rald.getId() > 0);
		
		List<RequestLocationDocument> raldList = DartObjectFactory.getInstance().getRequestLocationDocumentDAO().listByRequestId(request.getId());
		Assert.assertNotNull(raldList);
		Assert.assertTrue(raldList.size() > 0);
		Assert.assertTrue(raldList.contains(rald));

		DartObjectFactory.getInstance().getRequestLocationDocumentDAO().delete(rald);

		raldList = DartObjectFactory.getInstance().getRequestLocationDocumentDAO().listByRequestId(request.getId());
		Assert.assertNotNull(raldList);
		Assert.assertFalse(raldList.contains(rald));

	}
}
